// PART OF DVB DREAM SDK 2.6   2014 05 31
// Conversion by X05,  Updates by rel

// Please do not hesitate to ask your questions related to ModuleAPI usage in DD forum or by email rreloc@yahoo.com
	
#pragma pack(push, DDAPI, 1)

#ifndef MODULE_INCLUDE
	#define MODULE_INCLUDE

#define MODULE_API_1_0     	0x1000000 // v1.0
#define MODULE_API_1_1     	0x1010000 // v1.1
#define MODULE_API_1_2     	0x1020000 // v1.2
#define MODULE_API_1_3     	0x1030000 // v1.3
#define MODULE_API_1_4     	0x1040000 // v1.4
#define MODULE_API_1_4_1 	0x1040100 // v1.4.1
#define MODULE_API_1_4_2 	0x1040200 // v1.4.2
#define MODULE_API_1_4_3 	0x1040300 // v1.4.3
#define MODULE_API_1_4_4 	0x1040400 // v1.4.4	  DD v0.8.7a
#define MODULE_API_1_4_5 	0x1040500 // v1.4.5	  DD v0.8.7b	
#define MODULE_API_1_5 		0x1050000 // v1.5	  DD v1.0
#define MODULE_API_1_6 		0x1060000 // v1.6	  DD v1.BeforeChannelChange#define MODULE_API_1_7 		0x1070000 // v1.7	  DD v1.3		
#define MODULE_API_1_8 		0x1080000 // v1.8	  DD v1.5
#define MODULE_API_1_9 		0x1090000 // v1.9	  DD v1.5g - v1.6
#define MODULE_API_2_0 		0x2000000 // v2.0	  DD v2.0
#define MODULE_API_2_1 		0x2010000 // v2.1	  DD v2.1a
#define MODULE_API_2_2 		0x2020000 // v2.2	  DD v2.2a
#define MODULE_API_2_3 		0x2030000 // v2.3	  DD v2.3
#define MODULE_API_2_6 		0x2060000 // v2.6	  DD v2.6

#define MODULE_API_CURRENT  MODULE_API_2_6

#define WM_MODULE_MSG       WM_USER + 321

// Module API commands
#define DDMODAPI_GET_SIGNALINFO       0x0100001
#define DDMODAPI_SEND_DISEQC          0x0100002 // Sends raw diseqc commands
#define DDMODAPI_GET_CHANNEL_ID       0x0100003 // Gets Channel ID
#define DDMODAPI_SET_CHANNEL_BY_CHID  0x0100004
#define DDMODAPI_START_RECORD         0x0100005
#define DDMODAPI_STOP_RECORD          0x0100006
#define DDMODAPI_DISABLE_SHORTCUTS    0x0100007 // Removes default menu shortcuts
#define DDMODAPI_GET_TRANSLATED_STR   0x0100008 // To use DD localization in modules
#define DDMODAPI_GET_ENVIRONMENT      0x0100009 // Gets some DD variables, state info.
#define DDMODAPI_SET_ENVIRONMENT      0x010000A // Sets ``  ``
#define DDMODAPI_GET_RECFILENAME      0x010000B // Generates a file name to record
#define DDMODAPI_START_FILTER         0x010000C
#define DDMODAPI_STOP_FILTER          0x010000D
#define DDMODAPI_DVB_COMMAND          0x010000E // Send keys to CSA
#define DDMODAPI_SET_TUNER            0x010000F // Sets tuner directly
#define DDMODAPI_ADD_SCHEDULED_RECORD 0x0100010
#define DDMODAPI_GET_EPG_CURRENT      		0x0100013 // Only current program's info
#define DDMODAPI_GET_EPG_FOLLOWING    		0x0100014 // Only following program's info
#define DDMODAPI_GET_CHANNEL_INFO     		0x0100015 // Gets current channel's parameters
#define DDMODAPI_REFRESH_CHLIST       		0x0100016 // Refreshs channel list
#define DDMODAPI_ADD_LOG              		0x0010017 // Adds a log line to dvbdream.log file
#define DDMODAPI_REPAINT_OSD_PICTURE   		0x00100018 // Paints OSD picture
#define DDMODAPI_REMAKE_OSD_TRANSPARENCY   	0x00100019 // Remake OSD transparency
#define DDMODAPI_SHOW_OSD   				0x0010001A // Shows OSD window
#define DDMODAPI_HIDE_OSD   				0x0010001B // Hides OSD window
#define DDMODAPI_START_EPG   				0x0010001D // Starts EPG parser
#define DDMODAPI_STOP_EPG   				0x0010001E // Stops EPG parser
#define DDMODAPI_GET_VIDEO_INFO   			0x0010001F // Gets video information
#define DDMODAPI_SET_CHANNEL_BY_CHNO   		0x00100020
#define DDMODAPI_SET_OSD_COLORKEY           0x00100021
#define DDMODAPI_QUIT                       0x00100022 // stops current record (if available) and quits
#define DDMODAPI_POWEROFF                   0x00100023 // poweroff system
#define DDMODAPI_GET_TRANSPONDER_INFO       0x00100025
#define DDMODAPI_GET_DD_VERSION             0x00100026 // Gets DvbDream Version DWORD
#define DDMODAPI_GET_API_VERSION            0x00100027 // Gets ModuleAPI Version DWORD
#define DDMODAPI_SET_DISPLAY_MODE			0x00100028
#define DDMODAPI_GET_DISPLAY_MODE			0x00100029
#define DDMODAPI_GET_DISPLAY_HANDLE   		0x0010002B
#define DDMODAPI_GET_DISPLAY_OWNER_HANDLE 	0x0010002C	
#define DDMODAPI_GET_DEVICE_INFO	   		0x0010002D	
#define DDMODAPI_GET_FILE_INFO  				0x0010002E
#define DDMODAPI_PLAYFILE 							0x0010002F
#define DDMODAPI_PAUSEFILE  						0x00100030
#define DDMODAPI_GET_RECORD_PATH 				0x00100031
#define DDMODAPI_OSD_CREATE_SURFACE 		0x00100032
#define DDMODAPI_OSD_SHOW_SURFACE  			0x00100033
#define DDMODAPI_OSD_HIDE_SURFACE 			0x00100034
#define DDMODAPI_OSD_GET_SURFACE_BITMAP 0x00100035
#define DDMODAPI_OSD_REPAINT_SURFACE 	0x00100036
#define DDMODAPI_OSD_SET_TRANSPARENCY  	0x00100037
#define DDMODAPI_OSD_DESTROY_SURFACE 	0x00100038
#define DDMODAPI_OSD_GET_WINDOW_HANDLE 	0x00100039
#define DDMODAPI_GET_RECORDING_STATUS  	0x0010003A

//#define DDMODAPI_CHL_GET_POINTER		0x0010003B // DEPRECIATED!  use DDMODAPI_CHL_GET_POINTER2 instead.

#define DDMODAPI_CHL_SAVE				0x0010003C // Saves internal CHL buffer to disc
#define DDMODAPI_CHL_LOAD				0x0010003D // Loads CHL file to internal CHL buffer
#define DDMODAPI_RENDERLESS_MODE		0x0010003E // Enables or disables Renderless Mode
#define DDMODAPI_CHL_API                0x0010003F // CHL API functions via API structure
#define DDMODAPI_SELECT_CHANNEL_BY_CHID 0x00100040 // Just selects in treeview
#define DDMODAPI_START_PIP_RECORD 		0x00100041
#define DDMODAPI_STOP_PIP_RECORD 		0x00100042
#define DDMODAPI_START_RECORD_ALL 		0x00100043
#define DDMODAPI_STOP_RECORD_ALL 		0x00100044
#define DDMODAPI_ADD_PIP_RECORD 		0x00100045
#define DDMODAPI_MINIMIZE				0x00100046
#define DDMODAPI_QUIT_AFTER_RECORD 		0x00100047
#define DDMODAPI_SHUTDOWN_AFTER_RECORD 	0x00100048
#define DDMODAPI_GET_DATA 				0x00100049
#define DDMODAPI_SET_DATA 				0x0010004a
#define DDMODAPI_ADD_RECORD 			0x0010004b
#define DDMODAPI_GET_INTERFACE_LIST 	0x0010004c
#define DDMODAPI_SWITCH_DEVICE 			0x0010004d // specified by interface name and dev. no
#define DDMODAPI_GET_TP_LIST 			0x0010004e // get transponder list f specified sat
#define DDMODAPI_GET_SAT_LIST 			0x0010004f // get the channel list  (sorted as E to W)
#define DDMODAPI_GET_SETTINGS_POINTER 	0x00100050 // internal settings structure
#define DDMODAPI_STOPFILE   			0x00100051 // Stops playback. if lparam=1 , resets channel
#define DDMODAPI_SEEKFILE 				0x00100052 // Seeks in the file (in playback mode)
#define DDMODAPI_GET_KEYS_POINTER		0x00100053
#define DDMODAPI_GET_SELECTED_CHID		0x00100054	
#define DDMODAPI_START_EPG2 			0x00100055 // new {Starts EPG parser}
#define DDMODAPI_STOP_EPG2 				0x00100056 // new {Stops EPG parser}
#define DDMODAPI_SET_RECFILENAME		0x00100057 // new {Sets the record file name}
#define DDMODAPI_SET_RECFORMAT			0x00100058 // new {Sets the record format}

#define DDMODAPI_PIP_OPEN 				0x00100059
#define DDMODAPI_PIP_CLOSE 				0x0010005a
#define DDMODAPI_PIP_SHOW 				0x0010005b
#define DDMODAPI_PIP_HIDE 				0x0010005c
#define DDMODAPI_PIP_REC_START 			0x0010005d
#define DDMODAPI_PIP_REC_STOP 			0x0010005e
#define DDMODAPI_PIP_GET_DATA 			0x0010005f
#define DDMODAPI_PIP_SET_DATA 			0x00100060
#define DDMODAPI_GET_PIPCHLS 			0x00100061 // Get all channels on the cur. transponder
#define DDMODAPI_SET_AUDIO_PID 			0x00100062
#define DDMODAPI_SET_ASPECT_RATIO 		0x00100063

#define DDMODAPI_GET_TUNER 				0x00100064
#define DDMODAPI_SAVE_SNAPSHOT 			0x00100065
#define DDMODAPI_GET_VIEWABLE 			0x00100066
#define DDMODAPI_SET_VIEWABLE 			0x00100067
#define DDMODAPI_CLEAR_VIEWABLE			0x00100068
	
#define DDMODAPI_GET_EPG_CURRENT2 		0x00100069 // encoded epg, need to decode text#define 
#define DDMODAPI_GET_EPG_FOLLOWING2 	0x0010006A // encoded epg, need to decode text
#define DDMODAPI_GET_REC_STATS 			0x0010006B // gets the status of all active records

#define DDMODAPI_SET_STREAM_CB 			0x0010006C // sets stream callback to modify the steam
#define DDMODAPI_FREE_STREAM_CB 		0x0010006D // frees stream callback to modify the steam
#define DDMODAPI_RESET_DIRECTSHOW 		0x0010006E // resets the DirectShow / video subsystem
#define DDMODAPI_TUNE_DIALOG 			0x0010006F // displays the tune dialog with the given TP parameters
#define DDMODAPI_TUNE_DIALOG2 			0x00100070 // displays the tune dialog with the given TP parameters and starts scan
#define DDMODAPI_SHOW_SCHEDULER 		0x00100071 // displays the scheduler dialog
#define DDMODAPI_STOP_DEVICE 			0x00100072 // stops device
#define DDMODAPI_START_DEVICE	 		0x00100073 // starts device


#define DDMODAPI_CACHED_EPG_GET_INTERFACE 		0x00100074 // gets cached EPG interface
#define DDMODAPI_CACHED_EPG_CHECK_IF_ENABLED 	0x00100075 // checks if cached EPG is enabled
#define DDMODAPI_CACHED_EPG_GET_CURRENT 		0x00100076 // gets current and following events,  array of TEPGInfo3 (2 items)
#define DDMODAPI_CACHED_EPG_RESET 				0x00100077 // clears EPG cache

#define DDMODAPI_GET_GENERIC_INTERFACE		 	0x00100078 // gets generic interfac
#define DDMODAPI_GET_BDA_FILTERS 				0x00100079 // returns BDA tuner and capture filter pointers

#define DDMODAPI_FREEZE_TVWINDOW 		0x0010007a // fixes TV window position, used by EPGPlus 
#define DDMODAPI_UNFREEZE_TVWINDOW 		0x0010007b // frees TV window, used by EPGPlus 
	
#define DDMODAPI_CHL_GET_POINTER2		0x0010007c // Internal CHL accessible through this

#define AR_FREE 			0
#define AR_4x3 				1
#define AR_16x9 			2
#define AR_EMBEDDED_4x3		3 // invalid for PIP windows
#define AR_EMBEDDED_16x9	4 // invalid for PIP windows
#define AR_STRETCH_EMBEDDED_4x3		5 // invalid for PIP windows
#define AR_STRETCH_EMBEDDED_16x9 	6 // invalid for PIP windows

#define MAX_PIPS	20 // Max number of PIP windows that DD can support



// --- CHL API Functions ---}
// Function Type
#define CHL_SAT		1
#define CHL_CHAN	2
#define CHL_TP		3

//Sub Function
#define CHL_ADD		1
#define CHL_DEL		2
#define CHL_GET		3
#define CHL_SET		4



// Module Type
#define MODTYPE_NONE                  0x0 // Generic Module
#define MODTYPE_SCHEDULER             0x1
#define MODTYPE_EPG                   0x2
#define MODTYPE_TELETEXT              0x3
#define MODTYPE_SUBTITLE              0x4
#define MODTYPE_REMOTE                0x5
#define MODTYPE_POSITIONER            0x6
#define MODTYPE_SOFTCAM               0x7
#define MODTYPE_PREVIEW               0x8
#define MODTYPE_SNAPSHOT              0x9
#define MODTYPE_IMPORT                0xA
#define MODTYPE_EXPORT                0xB
#define MODTYPE_OSD                   0xC
#define MODTYPE_CHLIST_TOOL           0xD
#define MODTYPE_RECORD                0xE   

// DD Events,  sent to module through OnDDEvent
#define DDEVENT_BEFORE_DISPLAYMODE    		0x00200001
#define DDEVENT_AFTER_DISPLAYMODE     		0x00200002
#define DDEVENT_BEFORE_RESIZE         		0x00200003
#define DDEVENT_AFTER_RESIZE          		0x00200004
#define DDEVENT_ON_VOLUME_CHANGE      		0x00200005
#define DDEVENT_ON_OSD_INFO           		0x00200006
#define DDEVENT_ADD_SCHEDULED_RECORD  		0x00200007
#define DDEVENT_ON_MINIMIZE  		  		0x00200008
#define DDEVENT_AFTER_INITIALITION   		0x00200009
#define DDEVENT_ON_START_RECORD   			0x0020000A
#define DDEVENT_ON_STOP_RECORD   			0x0020000B
#define DDEVENT_ON_KEYBOARD   				0x0020000C
#define DDEVENT_ON_REMOTE  					0x0020000D
#define DDEVENT_ON_DEVICE_RESTART 			0x0020000E
#define DDEVENT_ON_CH_KEYING_COMPLETE		0x0020000F
#define DDEVENT_ON_WINDOW_NOTIFICATION_MSG  0x0200010
#define DDEVENT_ON_START_RENDERLESSMODE  	0x00200011
#define DDEVENT_ON_STOP_RENDERLESSMODE  	0x00200012
#define DDEVENT_ON_STOP_COMMUNICATION  		0x00200013 // DD asks module to stop sending MODAPI messages
#define DDEVENT_ON_START_COMMUNICATION  	0x00200014 // Module now can start sending MODAPI messages			
#define DDEVENT_ON_CH_BROWSE 				0x0200015
#define DDEVENT_ON_CH_LIST_UPDATE			0x00200016
#define DDEVENT_ON_MUTE						0x00200017
#define DDEVENT_ON_CHL_POINTER_CHANGE		0x00200018
#define DDEVENT_BEFORE_CACHE_RESTART 		0x00200019
#define DDEVENT_AFTER_CACHE_RESTART 		0x0020001a
#define DDEVENT_BEFORE_SCAN			0x0020001b
#define DDEVENT_AFTER_SCAN			0x0020001c
#define DDEVENT_BEFORE_CHANNEL_CHANGE 		0x0020001d
#define DDEVENT_AFTER_CHANNEL_CHANGE 		0x0020001e



#define WM_REMOTE_MSG   			WM_USER + 322
#define WM_REMOTE_DEVICE_MSG   		WM_USER + 323	

#define RMT_POWER   	0x00000001 // Required
#define RMT_MUTE   		0x00000002 // Required
#define RMT_0  	 		0x00000003 // Required
#define RMT_1  			0x00000004 // Required
#define RMT_2   		0x00000005 // Required
#define RMT_3   		0x00000006 // Required
#define RMT_4  			0x00000007 // Required
#define RMT_5  			0x00000008 // Required
#define RMT_6   		0x00000009 // Required
#define RMT_7   		0x0000000a // Required
#define RMT_8   		0x0000000b // Required
#define RMT_9   		0x0000000c // Required
#define RMT_UP   		0x0000000d // Required
#define RMT_DOWN   		0x0000000e // Required
#define RMT_LEFT  		0x0000000f // Required
#define RMT_RIGHT   	0x00000010 // Required
#define RMT_OK   		0x00000011 // Required
#define RMT_RECORD   	0x00000012 // Required
#define RMT_RECALL   	0x00000013  /*Back to previous channel*/
#define RMT_FULLSCREEN  0x00000014 // Required
#define RMT_TELETEXT   	0x00000015
#define RMT_EPG   		0x00000016
#define RMT_TAB   		0x00000017 // Required (to switch between ch.list tabs)
#define RMT_INFO   		0x00000018  /*Display channel number/name*/  // Required
#define RMT_OPTIONAL1   0x00000019
#define RMT_OPTIONAL2   0x0000001a
#define RMT_OPTIONAL3   0x0000001b
#define RMT_OPTIONAL4   0x0000001c
#define RMT_OPTIONAL5   0x0000001d
#define RMT_OPTIONAL6   0x0000001e
#define RMT_OPTIONAL7   0x0000001f
#define RMT_OPTIONAL8   0x00000020
#define RMT_OPTIONAL9   0x00000021
#define RMT_PLAY 		0x00000022
#define RMT_STOP 		0x00000023
#define RMT_FORWARD 	0x00000024
#define RMT_REWIND 		0x00000025
#define RMT_PAUSE 		0x00000026
#define RMT_SCHEDULER	0x00000027
#define RMT_MENU 		0x00000028 // Required
#define RMT_RED 		0x00000029
#define RMT_GREEN 		0x0000002a
#define RMT_YELLOW 		0x0000002b
#define RMT_BLUE 		0x0000002c
#define RMT_RADIO 		0x0000002d
#define RMT_RECORDLIST 	0x0000002e
#define RMT_EXIT 		0x0000002f // Required
#define RMT_PIP 			0x00000030 // new
#define RMT_ASPECT_RATIO	0x00000031 // new
#define RMT_SNAPSHOT  		0x00000032 // new
#define RMT_LANGUAGE 		0x00000033 // new

#define  RMT_CODE_COUNT	51

// Polarizations
#define POL_HORIZONTAL          0  /* 18 Volt */
#define POL_VERTICAL            1  /* 13 Volt */
#define POL_LNBPOWEROFF 		10 /* 0 Volt */
	
	
// FEC,  ETSI 302 307
#define FEC_AUTO  0x00
#define FEC_1_2  0x12
#define FEC_1_3  0x13
#define FEC_1_4  0x14
#define FEC_2_3  0x23
#define FEC_2_5  0x25
#define FEC_3_4  0x34
#define FEC_3_5  0x35
#define FEC_4_5  0x45
#define FEC_5_6  0x56
#define FEC_7_8  0x78  // not in specs (used by DN)
#define FEC_8_9  0x89
#define FEC_9_10  0x9a
//  FEC 5/11 and 3/5 used by DCII only
// FEC 6/7  is defined in DVB World SDK
	

// LNB Selection - Khz
#define LNB_SELECTION_0   		0
#define LNB_SELECTION_22   		1
#define LNB_SELECTION_33   		2
#define LNB_SELECTION_44   		3
#define LNB_SELECTION_COUNT   	4

// Tone Burst  (Simple Diseqc)
#define TONEBURST_NONE	0
#define TONEBURST_1		1
#define TONEBURST_2		2

// QAM Values
#define OBSOLETE_MOD_DVBC_QAM_4   	2 // DVB-C: Modulation:  4-QAM
#define OBSOLETE_MOD_DVBC_QAM_16   	3 // DVB-C: Modulation:  16-QAM
#define OBSOLETE_MOD_DVBC_QAM_32   	4 // DVB-C: Modulation:  32-QAM
#define OBSOLETE_MOD_DVBC_QAM_64   	5 // DVB-C: Modulation:  64-QAM (default)
#define OBSOLETE_MOD_DVBC_QAM_128   	6 // DVB-C: Modulation: 128-QAM
#define OBSOLETE_MOD_DVBC_QAM_256   	7 // DVB-C: Modulation: 256-QAM

//  DVB-S Modulations,  ETSI DVB-S2 March 2005 specs introduces 4 modulation types
#define MOD_DVBS_QPSK  		0
#define MOD_DVBS_8PSK  		1 // DVB-S2 8PSK
#define MOD_DVBS_16APSK  	2
#define MOD_DVBS_32APSK  	3
#define MOD_TURBO_QPSK  	4 // Dish Network QPSK (Turbo)
#define MOD_TURBO_8PSK  	5 // Dish Network 8PSK (Turbo)
#define MOD_DVBS_NBC_QPSK 	6 // DVB-S2 QPSK (NBC)  
#define MOD_DVBC_QAM_4 		102 // DVB-C: Modulation:  4-QAM
#define MOD_DVBC_QAM_16 	103 // DVB-C: Modulation:  16-QAM
#define MOD_DVBC_QAM_32 	104 // DVB-C: Modulation:  32-QAM
#define MOD_DVBC_QAM_64 	105 // DVB-C: Modulation:  64-QAM (default)
#define MOD_DVBC_QAM_128	106 // DVB-C: Modulation: 128-QAM
#define MOD_DVBC_QAM_256 	107 // DVB-C: Modulation: 256-QAM


// Spectral Inversion
#define SPECTRAL_INVERSION_AUTO   	2
#define SPECTRAL_INVERSION_ON   	0
#define SPECTRAL_INVERSION_OFF   	1

	
// Pilot values (DVB-S2 Only)
#define PILOT_AUTO 	0
#define PILOT_ON 	1
#define PILOT_OFF 	2

// Roll-Off values (DVB-S2 Only)
#define ROLL_OFF_AUTO	0
#define ROLL_OFF_20	 	1
#define ROLL_OFF_25	 	2
#define ROLL_OFF_35	 	3
  	

// Channel Types
#define CHTYPE_TV               1
#define CHTYPE_RADIO            2
#define CHTYPE_DATA             3

// DVB Audio Types
#define AUDIO_ISO11172          0x0 // MPEG-1 Audio
#define AUDIO_ISO13818          0x1 // MPEG-2 Audio
#define AUDIO_AC3               0x2	// AC3 (Dolby Digital)
#define AUDIO_ISO14496 			0x3 // MPEG-4 Audio
#define AUDIO_DOLBY_E 			0x4 // Dolby-E
#define AUDIO_EAC3              0x5	// E-AC3 (Dolby Digital Plus)
#define AUDIO_DTS               0x6	// DTS
#define AUDIO_TYPEMASK          0xF

// Stream-Filter Types
#define FT_TSPAYLOAD           	1 // 184 byte packets, TS payload
#define FT_TSFULL              	2 // 188 byte packets, TS whole packet
#define FT_SECTION 				3 //Section filter, allows bit masks for filtering by header
#define FT_SECTION_BUFFER 		4 // Same as above but it doesn't call a callback, fills
//  a buffer instead.  Runs once. In other words, automatically stopped after
//  one section buffered
#define FT_PES 					5

#define INVALID_FILTER_HANDLE   0xFFFFFFFF
	


// OSD Constants
#define OSD_WIDTH               1024
#define OSD_HEIGHT              768


// Display Modes
#define DISPLAYMODE_NORMAL  	0x00000001
#define DISPLAYMODE_FULLSCREEN 	0x00000002
#define DISPLAYMODE_TVWINDOW  	0x00000003


#define VIDEOTYPE_ISO13818	0 // MPEG-2
#define VIDEOTYPE_ISO11172	1 // MPEG-1
#define VIDEOTYPE_H264 		2 // AVC h264
#define VIDEOTYPE_ISO14496	3 // MPEG-4
#define VIDEOTYPE_HEVC		4 // HEVC h265



// Tuner Types
#define TUNERTYPE_DVBS  		0x00000001
#define TUNERTYPE_DVBC  		0x00000002
#define TUNERTYPE_DVBT  		0x00000003
#define TUNERTYPE_ATSC  		0x00000004


// Diseqc Values
#define DISEQC_NONE			0
#define DISEQC_SIMPLE_A		1
#define DISEQC_SIMPLE_B		2
#define DISEQC_LEVEL_1_A_A	3
#define DISEQC_LEVEL_1_B_A	4
#define DISEQC_LEVEL_1_A_B	5
#define DISEQC_LEVEL_1_B_B	6
#define DISEQC_PORT1		3
#define DISEQC_PORT2		4
#define DISEQC_PORT3		5
#define DISEQC_PORT4		6

// Transparency Values
#define TRANSPARENCY_NONE 	 	0x00000000
#define TRANSPARENCY_LEVEL1 	0x00000001
	
// Chroma format
#define CHROMA_RESERVED	0
#define CHROMA_4_2_0	1
#define CHROMA_4_2_2 	2
#define CHROMA_4_4_4 	3
  
// Window message for notifications.
// attached to DD's main window, triggers a DDEvent with TWndMessage param
#define WM_MODULE_NOTIFICATION_MSG 	WM_USER + 500

// Constansts to use in  DDMODAPI_GET_DATA or DDMODAPI_SET_DATA
#define  DI_OSD_NOWNEXT_FONT  	1
#define  DI_INT_DATA  		 	2
// --------------------------------------------------------------------------------

typedef struct
{	
    DWORD dwSize;
    BOOL bActive; // read only
    int ChId; // read only
    int PosX;
    int PosY;
    int Width;
    int Height;
    HWND hwndFrame; // read only
    HWND hwndVideo; // read only
    int AspectRatio;
    BOOL bFullScreen;
    BOOL bStayOnTop;
    BOOL bRecording;  // read only
    BOOL bMute;
}TPIP_DATA, *PPIP_DATA;


typedef struct
{
    DWORD dwCount;
    int ChIds[128];
} TPIP_CHLS, *PPIP_CHLS;



// Stream-Filter Callback for DDMODAPI_START_FILTER
  typedef BOOL _stdcall LPF_FilterHook(unsigned char *Buf, int Len, DWORD hFilter);
  
  // Stream Callback for DDMODAPI_SET_STREAM_CB
  // InLen and OutLen: always will be 188 (for now)
  typedef BOOL _stdcall LPF_StreamCB(unsigned char *InBuf, int InLen, unsigned char **pOutBuf, int *pOutLen);



typedef struct
{
    int Size;
    BYTE Style;
    BYTE Charset;
    char Name[32];
    int Color;
} TDDFont;


// Module Definition Information, filled by module
typedef struct
{
    DWORD dwModuleAPI;
    char szModuleName[32];
    char szModuleAuthor[32];
    char szModuleEmail[32];
    DWORD dwModuleVer;
    WORD wShorCut;
    DWORD dwModuleType; // to automatically assign to related icon
    DWORD dwRequiredDDver; // required DD version
	HWND hMainWnd; // handle of the DD main window (filled by DD)	
} TModuleInfo, *PModuleInfo;

/* ----- NOTES ABOUT TModuleInfo -----
   DD sends following values to the module
      - DD's internal module API version in dwModuleAPI
      - main window's handle in hMainWnd

    Module can overwrite these input values in TModuleInfo.
    It recommended to fill whole structure (in OnGetModuleInfo).
    dwRequiredDDver can be 0 or required DD version (as hex) to make module work
    properly. (this is very useful for version-compatibility check in DD side)
*/

// Initialization Information, filled by DD
typedef struct 
{
    HWND hMainWnd;
    DWORD dwVersion;
    DWORD dwDDInstance;
	BYTE CharSet;
	WORD reserved;    // new in DD v2.3
	BYTE reserved2;   // new in DD v2.3
    BYTE TunerIndex;  // new in DD v2.3    Device index for the given interface
    
    // following added for ModuleAPI 1.9
    char DevName[256]; // DD Device Interface File Name (*.dev)
    char TunerName[256]; // BDA Tuner Filter Name / Device Tag
    int TunerType; // TUNERTYPE_xxxx
}TInitInfo, *PInitInfo;


// parameter for DDMODAPI_GET_DEVICE_INFO
typedef struct 
{
    DWORD dwSize;
    char DevName[256]; // DD Device Interface File Name (*.dev)
    char TunerName[256]; // BDA Tuner Filter Name / Device Tag
    int TunerType; // TUNERTYPE_xxxx
    unsigned char MAC[6];
    BOOL bSupportsLNBPowerOFF;
    BOOL bSupportsRawDiseqc;
    int MaxHwFilters;
  } TGDeviceInfo, *PGDeviceInfo;

// Translation Request/Answer
typedef struct
{
    DWORD dwSize;
    char szName[256];
    char szResult[256];
}TTranslation, *PTranslation;

// Signal Information
typedef struct 
{
    DWORD dwSize;
    BYTE Level;
    BYTE Quality;
    BYTE Locked;
	double SNR; // signal-to-noise ratio (in dB) , http://en.wikipedia.org/wiki/Decibel    http://en.wikipedia.org/wiki/Signal-to-noise_ratio
  	double BER; // bit error rate (unitless ratio) ,  http://en.wikipedia.org/wiki/Bit_error_rate    
}TSignalInfo, *PSignalInfo ;

// Raw Diseqc Command Data
typedef struct 
{
    DWORD dwSize;
    BYTE iLength;
    BYTE Data[32];
}TDiseqcCmd, *PDiseqcCmd;


// DD Environment Info
typedef struct
{
    DWORD dwSize;
    BYTE  bThreadedSwitching;
    BYTE  bScheduledRecording;
    DWORD pGraph;  // read-only
    BYTE  bOSDEnabled; // read-only
    DWORD lTimeBias; // read-only
    BYTE  bSchedulerInstalled; // read-only
    HBITMAP hbmpOSD; // read-only   
    BYTE bRelease; // if bRelease is true, verbose logging is disabled // read-only
    DWORD dwOSDTimeOut; // read-only   	
    BYTE bCHLReadOnly; // read-only
    char CHLPath[256]; // read-only
    char PluginsPath[256]; // read-only
    BYTE bAribEPG; // read-only
   	BYTE bUseSystemCodePage; // read-only
   	DWORD EPGCodePage; // read-only
   	BYTE bRegged; // read-only
   	BYTE bCustomizeForNa; // read-only, GUI & settings are customized for North America
    DWORD dwVersion; // DD Version
    DWORD dwReleaseDate; // DVB Dream Release Date   	
    BYTE bCollectEPGForOtherSatellites; // read-only
}TEnvironment, *PEnvironment;

// Audio Info, holds audio-pids and their types
typedef struct
{
    WORD wCurrent;     // Row-No of the current pid
    WORD wCount;       // Total pid count
    DWORD dwFlags[64]; // Audio type
    WCHAR wPID[64];    // Audio pids
}TAudioInfo, *PAudioInfo;

// CA Info, holds ECM/EMM pids
typedef struct
{
    WORD wCurrent;     // Row-No of the current pid
    WORD wCount;       // Total pid count
    WCHAR wCAType[64]; // CA-Type Codes
    WCHAR wPID[64];    // ECM or EMM pids
}TCAInfo, *PCAInfo;

// Channel Info
typedef struct
{
    DWORD dwSize;
    WORD wNID;
    WORD wSID;
    WORD wSatPos;
    DWORD dwChId;
    char ChName[64];
    char Provider[64];
    BYTE ChType;
    BYTE Scrambled;
    WORD wVideo;
    WORD wPMT;
    WORD wPCR;
    WORD wTTX;
    TAudioInfo Audio;
    TCAInfo ECM;
    TCAInfo EMM;
    WORD wChNo;
    WORD wTID;
}TChannelInfo, *PChannelInfo;


// Transponder Info
typedef struct 
{
    int dwSize;
    int dwModulation;
    int dwFreq;      // Frequency
    BYTE  Pol;         // Polarization
    int dwSr;        // Symbol Rate,  DVB-S/DVB-C only
    	
	// LOF for DVB-S  
	// (This has been used as QAM for DVB-C in the previous DD versions, 
	// now use dwModulation for QAM/DVB-C Modulation !)
	// (Also in past versions, it has been used as BandWidth for DVB-T,
	// now use dwBandWidth for DVB-T Bandwidth !)    	
    int dwLOF;       // LOF for DVB-S, QAM for DVB-C
    	
    int dwLnbKHz;    // DVB-S only
    int dwInversion; // Spectral Inversion
    int dwFec;       // Viterbi Rate, DVB-S only
    DWORD dwPilot;   // Pilot (DVB-S2)
    DWORD dwRollOff;	// RollOff (DVB-S2)
    DWORD dwBandWidth;	// DVB-T band width (Mhz,  i.e. 8 MHz, 7 MHz, 6 Mhz)
    DWORD dwSubStreamID; // PLP or MIS ID  for DVB-T2/C2/S2   (real value + 1,  0 = default state)
    DWORD dwPLSMode; // PLS Mode: Gold/Root/Combo Code (0 = none/default 1 = Root mode 2 = Gold mode 3 = Combo mode)
    DWORD dwPLSCode; // PLS Code: (default value is 0 for Gold, 1 for Root)    
} TTransponderInfo, *PTransponderInfo;

// DDMODAPI_SET_TUNER parameters
typedef struct 
{
    WORD wSatPos;
    TTransponderInfo tpi;
} TSetTunerParams, *PSetTunerParams;

// EPG Information
typedef struct
{
    DWORD dwSize;
    WORD wSat;            // Satellite, position code, e.g. 0130
    WORD wNetID;          // NID - Network
    WORD wSID;            // SID - Channel
    WORD wEventID;        // Event ID
    DWORD dwStartTime;    // Start-time in UNIX format
    DWORD dwDuration;     // Duration in UNIX format
    char EventName[257];      // Event name
    char ShortDescr[1025];     // Short Description
    char ExtendedDescr[1025]; // Extended Description
}TEPGInfo, *PEPGInfo;




#define MAX_ITEMS  16
	
typedef struct {	
	unsigned char NameLen;
	char Name[256];
	unsigned char ValueLen;
	char Value[256];	
} TEPGItem;



typedef struct {	
	unsigned short wNID;		// NID - Network
	unsigned short wTID;		// TID - Transponder
	unsigned short wSID;		// SID - Channel
	unsigned short wEventID;	// Event ID
	unsigned int dwStartTime;	// Start-time in UNIX format
	unsigned int dwDuration;	// Duration in UNIX format
	unsigned int dwRating;		// MPAA & Parental Rating - Bit mask
	unsigned short wContent;	// Content - Theme - Bit mask
	unsigned char OrgAirDate[8]; // Unknown date format particular to Dish Net (?)
	unsigned char EventNameLen;	
	char EventName[256];
	unsigned char ShortDescLen;
	char ShortDesc[256];
	unsigned short ExtendedDescLen;
	char ExtendedDesc[4096];
	unsigned char nItems;
	TEPGItem Items[MAX_ITEMS];		
} TEPGInfo2, *PEPGInfo2;

	
	// EPG callback type
typedef int _stdcall PEPGCallback(PEPGInfo pepg);
typedef int _stdcall PEPGCallback2(PEPGInfo2 pepg);
  
    

// DDMODAPI_START_FILTER Parameters
typedef struct
{
    DWORD dwSize;
    WORD wFilterType;
    WORD wPID;
    DWORD dwHookProc;  // Callback function
    DWORD dwHandle;   // Returned by DD
    BYTE FilterData[14]; // for section filters, added in v0.8.8
    BYTE FilterMask[14]; // for section filters, added in v0.8.8
    BYTE FilterLength; // for section filters, added in v0.8.8
    BYTE FilterTableID_Min;
    BYTE FilterTableID_Max;
    void *lpBuf;  // Section Buffer for FT_SECTION_BUFFER
    void *lpLen;  // Section Buffer Length (pointer to DWORD)
    BOOL bCRC;     // CRC Checking
    char Description[64]; // To describe filter function (in logs)
    BOOL bIgnoreDublicates; // Ignore the check for duplicate filters    	
    char Reserved[60];
}TStartFilterParams, *PStartFilterParams;


// DDMODAPI_DVB_COMMAND Parameters
/*
    Command Format:
               0 1 2 3 4 5 6 7 8 9 10 11 12 13
                       x                          0 = even keys in [6..13]
                       x                          1 = odd  keys in [6..13]
                           1 2 3 4 5  6  7  8     the  keys might need endian swapping!
     * First 4 bytes are not really necessary for DVB Dream, so any value is ok
*/                           
typedef struct
{
    DWORD dwSize;
    WORD wLen; 
    char Buf[32];
}TDVBCommand, *PDVBCommand;


// DDMODAPI_ADD_SCHEDULED_RECORD Parameters
typedef struct
{
    DWORD dwSize;      //
    DWORD dwStartTime; // Date/time in Unix form
    DWORD dwStopTime;  // Date/time in Unix form
    DWORD dwChID;      // Channel ID
}TScheduledRecord, *PScheduledRecord;


// Video Information
typedef struct
{
   DWORD dwSize;
   WORD Width;
   WORD Height;	
   int FrameRate;
   int AspectRatio;
   int BitRate;
   int Chroma;
}TVideoInfo, *PVideoInfo;



// DDMODAPI_OSD_CREATE_SURFACE Parameters 
typedef struct
{
	DWORD dwSize;
	DWORD dwLeft;
	DWORD dwTop;
	DWORD dwWidth;
	DWORD dwHeight;
	BYTE  Transparency;
}TOSDSurface, *POSDSurface;

typedef struct
{
  char szFileName[256];
  float PercentPlayed;
  BOOL bPlaying;
}TPlaybackInfo, *PPlaybackInfo;



// DDEVENT_ON_WINDOW_NOTIFICATION Parameters
typedef struct
{
    DWORD 	Msg;
    long	WParam;
    long	LParam; 
    long	Result;
}TWndMessage, *PWndMessage;



#define LNBTYPE_UNIVERSAL 		0 // Ku-Linear
#define LNBTYPE_KUCIRCULAR 		1 // Ku-Circular
#define LNBTYPE_C 				2
#define LNBTYPE_BANDSTACKED_DP_KU_HIGH	3 // DBS (12.2-12.7)
#define LNBTYPE_BANDSTACKED_DP_KU_LOW 	4 // FSS (11.7-12.2)
#define LNBTYPE_BANDSTACKED_KU_HIGH 	5 // (12.2-12.7)
#define LNBTYPE_BANDSTACKED_KU_LOW 		6 // (11.7-12.2)
#define LNBTYPE_BANDSTACKED_C			7 // (3.7-4.2)
#define LNBTYPE_LEGACY 				8
#define LNBTYPE_OTHER 				9
#define LNBTYPE_BANDSTACKED_START	3
#define LNBTYPE_BANDSTACKED_END		7
#define	LNBTYPE_JAPANESE_KU			10
#define	LNBTYPE_UNICABLE			11


// Audio Panning
#define	BOTH_CHANNELS 	0
#define	LEFT_CHANNEL 	1
#define	RIGHT_CHANNEL 	2

// --- CHL Channel List Structs -------------------------------------------
#define MAX_SATELLITES 128 // changed in v2.3,  old size was 64
#define MAX_FAVORITES  128 // changed in v2.3, old size was 64
// #define MAX_CHANNELS   8000   now it is unlimited and need to look at file size
#define MAX_AUDIO_PIDS 16
#define MAX_CA_PIDS    16  //64 -> 16
#define MAX_STR_SIZE   64 // changed in v2.3, old size was 32


typedef struct
{
    DWORD dwSign;
    DWORD dwVers;
    WORD wPassword;
    BYTE Reserved[16];
}TChlHeader, *PChlHeader;
  
  

typedef struct
{
    WORD wCount;   // {Total pid count}
    WORD wCurrent; // {Row-No of the current pid}
    WORD wPID[MAX_AUDIO_PIDS];     // {Audio pids}
    DWORD dwFlags[MAX_AUDIO_PIDS]; // {Audio type}
}TChlAudioInfo, *PChlAudioInfo;

typedef struct
{
    WORD wCount;   // {Total pid count}
    WORD wCurrent; // {Row-No of the current pid}
    WORD wCAType[MAX_CA_PIDS]; // {CA-Type Codes}
    WORD wPID[MAX_CA_PIDS]; // {ECM or EMM pids}    
    DWORD dwProviderID[MAX_CA_PIDS]; // {Provider IDs}   // New !
}TChlCAInfo, *PChlCAInfo;

typedef struct
{
    WORD wSatPos;
    DWORD dwFreq;
    DWORD dwSr;
    BYTE Pol;
    char ChName[MAX_STR_SIZE];
    char Provider[MAX_STR_SIZE];
    char ActualChName[MAX_STR_SIZE];
    BYTE ChType;
    BYTE Scrambled;
    WORD wNID;
    WORD wTID;
    WORD wSID;
    WORD wVideo;
    WORD wPMT;
    WORD wPCR;  
    WORD wTTX;   // {Teletext}
    WORD wChNo;  // new for 0.86
    WORD wChFav;    
    TChlAudioInfo Audio;
    TChlCAInfo ECM;
    TChlCAInfo EMM;
    BYTE Hide;
    BYTE bLocked;
    DWORD Creation;
    DWORD LastUpdate;
    BYTE ScanState;
    BYTE Imported;
    BYTE LastLevel;
    BYTE Modulation;
    BYTE FEC;
    BYTE VideoType;    // MPEG-2 or H264
    BYTE QuickFav;
    BYTE QuickFav2;    
    BYTE Pilot; // new in DD 2.0
    BYTE RollOff; // new in DD 2.0
    BYTE Bandwidth; // new in DD 2.0
    BYTE TunerType; // new in DD 2.0
    BYTE AudioPanning; // new in DD 2.2b
    DWORD SubStreamID; // PLP or MIS ID  for DVB-T2/C2/S2   (real value + 1,  0 = default state)      new in DD 2.2c
    DWORD dwPLSMode; // PLS Mode: Gold/Root/Combo Code (0 = none/default 1 = Root mode 2 = Gold mode 3 = Combo mode)
    DWORD dwPLSCode; // PLS Code
    BYTE Reserved[32];  // 2   
}TChlChannel, *PChlChannel;


typedef struct
{
    DWORD wPos;
    char SatName[64];
    DWORD dwLOF1;
    DWORD dwLOF2;
    DWORD dwLOFSW;
    BYTE Diseqc_Switch_Port;
    BYTE Diseqc_RawCmd_Len;
    BYTE Diseqc_RawCmd[32];
	BYTE F22Khz;    
	DWORD iItem;        // X05.51	
	BYTE Diseqc_UnCommitted;
    BYTE LNBType;
    BYTE MotorPos;
    BYTE UnicableSlotNo;
    DWORD UnicableSlotFreq;
    BYTE Reserved[64]; // changed in v2.3, old size was 3 [0..2]
}TChlSat, *PChlSat;

typedef struct
{
    char FavName[64];
    BYTE Reserved[16];
}TChlFav, *PChlFav;



// Complete structure of a chl file
typedef struct
{  	  
    TChlHeader Header;
    TChlSat Satellites[MAX_SATELLITES];
    TChlFav Favorites[MAX_FAVORITES]; 
    // from this offset, the storage area for the channels begins
    // it is unlimited, so MAX_CHANNELS must be found by dividing the size of
    // the whole space by the size of TChlChannel    
 //   TChlChannel Channels[MAX_CHANNELS]; 
}TCHL, *PCHL;


// --- CHL API functions ---
  	    
typedef struct 
{
	// update note by rel:  this structure added by X05 
    // for a module (which I forgot, was it temporary ?)
    DWORD wPos;
    DWORD freq;
    DWORD pol;
    DWORD sr;
    WORD fec;
    BYTE sig1;
    BYTE sig2;
}TChlTP, *PChlTP;



typedef struct // NOT IN USE AT THE MOMENT
{
    DWORD dwModeType;  // delete, add, insert, get
    DWORD dwListType;  // sat, chan, tp
    DWORD iItem;
    void * pItemStruct; //[sizeof TChlChannel];
}TCHLAPI, *PCHLAPI;

//////////////////////////////////////////////////////////////////////
// NEW STRUCTURES

typedef struct {
    char szInterfaceFileName[256];
    char szInterfaceName[256];
    DWORD dwInterfaceVersion;
    DWORD dwInterfaceAPI;
    char szInterfaceAuthor[256];
}TDDInterface, *PDDInterface;

typedef struct {
    DWORD dwCount;
    TDDInterface Devices[16];
}TDDInterfaceList, *PDDInterfaceList;

typedef struct {
    char szInterfaceFileName[256]; // i.e "bda.dev"
    DWORD dwDeviceNo;  // 0=first device  1=second device
}TSwitchDeviceParams, *PSwitchDeviceParams;

typedef struct {
    DWORD dwCount;
    WORD wSatPos;   // used as input parameter for DDMODAPI_GET_TP_LIST
    TTransponderInfo TPs[512];
}TTPList, *PTPList;

typedef struct {
    DWORD dwCount;
    int TunerType;
    TChlSat Sats[512];
}TSatList, *PSatList;



// constants and structures for DDMODAPI_GET_REC_STATS
#define  MAX_REC_SLOTS  64

typedef struct {
    int active;
    char file_name[1024];
    __int64 bytes_written;
    __int64 total_bytes_written;
    __int64 free_disk_space;
    __int64 total_disk_space;
    DWORD start_time;
    int rec_type;
} t_m_slot_info, *p_m_slot_info;

// parameter for DDMODAPI_GET_REC_STATS
typedef struct {  	 
  	     t_m_slot_info slots[MAX_REC_SLOTS];
} t_reclist, *p_reclist;
  



typedef struct {
	DWORD dwSignature;
	WORD wVersion;  
} TEPGCacheHdr, *PEPGCacheHdr;


typedef struct {
    WORD wNID; // NID - Network
    WORD wTID; // TID - Transponder
    WORD wSID; // SID - Channel
    WORD wEventID; // Event ID
    DWORD dwStartTime; // Start-time in UNIX format
    DWORD dwDuration; // Duration in UNIX format
    DWORD dwRating; // MPAA & Parental Rating - Bit mask
    WORD wContent; // Content - Theme - Bit mask
    BYTE OrgAirDate[8]; // Unknown date format particular to Dish Net (?)  
} TEPGCacheItemInfo, *PEPGCacheItemInfo;

typedef struct {
    DWORD dwItemSize; // including this , info and data parts
	WORD wSat; // Satellite, position code, e.g. 0130
    TEPGCacheItemInfo info;  
} TEPGCacheItemHdr, *PEPGCacheItemHdr;



  // EPG structure, texts is decoded, in unicode
typedef struct {	
	unsigned short wNID;		// NID - Network
	unsigned short wTID;		// TID - Transponder
	unsigned short wSID;		// SID - Channel
	unsigned short wEventID;	// Event ID
	unsigned int dwStartTime;	// Start-time in UNIX format
	unsigned int dwDuration;	// Duration in UNIX format
	unsigned int dwRating;		// MPAA & Parental Rating - Bit mask
	unsigned short wContent;	// Content - Theme - Bit mask
	unsigned char OrgAirDate[8]; // Unknown date format particular to Dish Net (?)
	unsigned char EventNameLen;	// in wide chars, without NULL char !
	wchar_t EventName[256];
	unsigned char ShortDescLen; // in wide chars, without NULL char !
	wchar_t ShortDesc[256];
	unsigned short ExtendedDescLen; // in wide chars, without NULL char !
	wchar_t ExtendedDesc[4096];
	unsigned char nItems;
	TEPGItem Items[MAX_ITEMS];		
} TEPGInfo3, *PEPGInfo3;


  typedef BOOL _stdcall LPF_FilterHook(unsigned char *Buf, int Len, DWORD hFilter);
  

  typedef int _stdcall LPF_lock_list();      // locks EPG cache for any further operation, first thing to do before any of following functions
  typedef int _stdcall LPF_unlock_list(); 	// unlocks EPG cache when done
  typedef int _stdcall LPF_get_count();		// gets number of events in the cache
  typedef PEPGCacheItemHdr _stdcall LPF_get_item(int item_index); // gets the event by given index
  typedef int _stdcall LPF_add(PEPGInfo2 pe); // adds an event to cache

	// DDMODAPI_CACHED_EPG_GET_INTERFACE paramater
typedef struct {	
    DWORD dwSize;
    LPF_lock_list *lock_list;
    LPF_unlock_list *unlock_list;
    LPF_get_count *get_count;
    LPF_get_item *get_item;
    LPF_add *add;
} TEPGCacheInterface, *PEPGCacheInterface;



  //---  DVB Dream Generic Function Interface -------
  // All fuctions are thread-safe
  
  // This function gets the language file translation for the specified item, from DVB Dream language files
  typedef int _stdcall LPF_get_language_file_str(char *item_name, char *item_value, int item_value_len);

// Decodes the coded string to unicode
// srclen: in bytes (including NULL termination)
// dstlen: in wide chars (including NULL termination)
// return: in wide chars (length if the string in dst) (including NULL termination)
  typedef int _stdcall LPF_decode_dvb_str(char *src, int srclen, wchar_t *dst, int dstlen);

// Decodes the coded string to ascii
// srclen: in bytes (including NULL termination)
// dstlen: in bytes (including NULL termination)
// return: in bytes (length if the string in dst) (including NULL termination)
  typedef int _stdcall LPF_decode_dvb_str2(char *src, int srclen, char *dst, int dstlen);

// Converts sat position code(satcodx code) to string in proper Eeast/West degree form
// pos_code: Satco DX satellite position code
// dst: string buffer
// dstlen: in bytes (including NULL termination)
// return: in bytes (length if the string in dst) (including NULL termination)
  typedef int _stdcall LPF_position_to_str(int pos_code, char *dst, int dstlen);

// Gets satellite name by looking up with sat position code(satcodx code)
// pos_code: Satco DX satellite position code
// dst: string buffer
// dstlen: in bytes (including NULL termination)
// return: in bytes (length if the string in dst) (including NULL termination)
  typedef int _stdcall LPF_get_satellite_name(int pos_code, char *dst, int dstlen);

  // DDMODAPI_GET_GENERIC_INTERFACE parameter
typedef struct {
    DWORD dwSize;
    LPF_get_language_file_str *get_language_file_str;
    LPF_decode_dvb_str *decode_dvb_str;
    LPF_decode_dvb_str2 * decode_dvb_str2;
    LPF_position_to_str *position_to_str;
    LPF_get_satellite_name *get_satellite_name;
} TGenericInterface, *PGenericInterface;


  // DDMODAPI_GET_BDA_FILTERS  parameter
typedef struct {  	  
    DWORD dwSize;
    void *tuner;   // IBaseFilter *tuner;
    void *capture;  // IBaseFilter *capture;
} tbda_filters, *pbda_filters;



// 1.7a
// Module Events
typedef BOOL (__stdcall *LPF_OnGetModuleInfo)(void* ModuleInfo);
typedef BOOL (__stdcall *LPF_OnModuleInit)(void* InitInfo);
typedef BOOL (__stdcall *LPF_OnModuleClose)();
typedef BOOL (__stdcall *LPF_OnModuleShow)();
typedef BOOL (__stdcall *LPF_BeforeChannelChange)(void* ChInfo);
typedef BOOL (__stdcall *LPF_AfterChannelChange)(void* ChInfo);
typedef BOOL (__stdcall *LPF_OnDDEvent)(DWORD EventType, void* EventParams);



#endif
 

#pragma pack(pop, DDAPI)
